// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 11, Aufgabe 7
// "Uhrzeiten"

class Time {
	int h, m;
	
	Time(int h, int m) {
		this.h = h; this.m = m;
	}
	
	void add(Time t) {
		int minutes = m + t.m;
		h = h + t.h + minutes / 60;
		m = minutes % 60;
	}
	
	int diff(Time t) {
		return Math.abs(minutes() - t.minutes());
	}
	
	int minutes() {
		return h * 60 + m;
	}
	
	public String toString() {
		return h + ":" + (m < 10 ? "0" : "") + m;
	}
}

public class A7 {
	
	public static void main(String args[]) {
		Time t1 = new Time(5, 42);
		Time t2 = new Time(3, 27);
		Out.print(t1 + " + " + t2 + " = ");
		t1.add(t2);
		Out.println(t1);
		
		t1 = new Time(5, 20);
		t2 = new Time(3, 10);
		Out.println(t1 + " - " + t2 + " = " + t1.diff(t2) + " Minuten");
		
		t1 = new Time(3, 20);
		Out.println(t1 + " => " + t1.minutes() + " Minuten");
	}
}
